#ifdef WIN32

#include "IConnectFactory.h"
#include "apcom/apcomlib.h"
#include "csf/Mutex.hpp"
#include "csf/ScopedLock.hpp"

namespace CSFUnified
{
	namespace MeetingStackCap
	{
		IConnectFactory * IConnectFactory::m_pInstance = NULL;
		static csf::Mutex mutex;

		IConnectFactory::IConnectFactory() : m_dwCookie(0)
		{
			InitializeAP(&m_dwCookie);
		}

		IConnectFactory::~IConnectFactory()
		{
			m_pInstance = NULL;
		}

		IConnectFactory* IConnectFactory::GetInstance()
		{
			csf::ScopedLock lock(mutex);
			if (m_pInstance == NULL)
			{
				m_pInstance = new IConnectFactory();
				m_pInstance->AddRef();
			}
			return m_pInstance;
		}

		stdapi IConnectFactory::ModuleCreateInstance(conREFIID riid, void **ppvObject)
		{
			return APCreateInstance(this, riid,NULL, m_dwCookie, ppvObject);
		}

		stdapi IConnectFactory::ModuleCreateInstanceEx(const tchar* pszServiceGroup, const tchar* pszServiceName,void **ppvObject)
		{
			return APCreateInstanceEx(this, pszServiceGroup,pszServiceName,NULL, m_dwCookie, ppvObject);
		}
	}
}

#endif